unit fROR_SiteParams;
{
================================================================================
*
*       Package:        ROR - Clinical Case Registries
*       Date Created:   $Revision: 28 $  $Modtime: 3/07/07 4:09p $
*       Site:           Hines OIFO
*       Developers:                     @domain.ext
*       Description:    Site Parameters Editor
*
*	Notes:
*
================================================================================
*	$Archive: /CCR v1.5/Current/fROR_SiteParams.pas $
*
* $History: fROR_SiteParams.pas $
 * 
 * *****************  Version 28  *****************
 * User: Vhaishgavris Date: 3/08/07    Time: 1:47p
 * Updated in $/CCR v1.5/Current
 * 
 * *****************  Version 27  *****************
 * User: Vhaishgavris Date: 1/25/07    Time: 9:57a
 * Updated in $/CCR v1.5/Current
 * 
 * *****************  Version 26  *****************
 * User: Vhaishgavris Date: 1/11/07    Time: 3:54p
 * Updated in $/CCR v1.5/Current
 * 
 * *****************  Version 25  *****************
 * User: Vhaishgavris Date: 11/23/05   Time: 1:48p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 24  *****************
 * User: Vhaishgavris Date: 9/30/05    Time: 4:49p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 23  *****************
 * User: Vhaishgavris Date: 9/21/05    Time: 3:51p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 22  *****************
 * User: Vhaishgavris Date: 9/20/05    Time: 8:38a
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 21  *****************
 * User: Vhaishgavris Date: 9/19/05    Time: 4:55p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 20  *****************
 * User: Vhaishgavris Date: 9/08/05    Time: 4:16p
 * Updated in $/CCR v1.0/Current
 * 
================================================================================
}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ToolWin, ComCtrls, StdCtrls, Buttons, ImgList, ActnList,
  uROR_Selector, uROR_ListView, ovcbase, ovcfiler, ovcstore,
  uROR_VistAStore, ovcstate, uROR_State, uROR_CustomControls,
  uROR_CustomListView, uROR_GridView, fROR_VistARegistries, o32editf,
  o32flxed, Menus, Grids, uROR_AdvColGrid, uROR_Errors, BaseGrid,
  AdvGrid, AdvCGrid, uROR_SearchEdit, uROR_CustomSelector,
  VA508AccessibilityManager;

type

  //-------------------------------- TDataGroup(s) ------------------------------

  TDataGroup = class(TPersistent)
  private
    fCode:     String;
    fIEN:      String;
    fSelector: TCCRSelector;
    fText:     String;

  public
    constructor Create;

    procedure AssignRawData(const RawData: String);

    property Code: String                                   read   fCode;

    property Selector: TCCRSelector                         read   fSelector
                                                            write  fSelector;

    property Text: String                                   read   fText;

  end;

  TDataGroups = class(TStringList)
  private
    fDataType: String;

  protected
    function  getObject(const anIndex: Integer): TDataGroup; reintroduce;
    procedure setObject(const anIndex: Integer; aValue: TDataGroup);

  public
    constructor Create(const aDataType: String);
    destructor Destroy; override;

    function  Add(aGroup: TDataGroup): Integer; reintroduce;
    procedure AssignRawData(RawData: TStrings);
    procedure Load(const aRegIEN: String);

    property Objects[const anIndex: Integer]: TDataGroup    read   getObject
                                                            write  setObject;
                                                            default;

    property DataType: String                               read   fDataType;

  end;

  //---------------------------- TFormSiteParameters ---------------------------

  TFormSiteParameters = class(TForm)
    pnlMain: TPanel;
    pgcMain: TPageControl;
    tsLabTests: TTabSheet;
    tsRegistryMeds: TTabSheet;
    ActionList: TActionList;
    acApply: TAction;
    tsNotifications: TTabSheet;
    Panel2: TPanel;
    pnlARVDrugsTop: TPanel;
    Splitter4: TSplitter;
    Panel4: TPanel;
    Panel5: TPanel;
    Panel12: TPanel;
    pnlRegMedsSearch: TPanel;
    pnlLocalRegMeds: TPanel;
    csRegistryDrugs: TCCRSelector;
    lsvGenericDrugs: TCCRGridView;
    acSave: TAction;
    vxsFormLayout: TCCRVistAStore;
    ccrFormState: TCCRFormState;
    ccrComponentState: TCCRComponentState;
    pnlToolbar: TPanel;
    cseRegistryDrugs: TCCRSearchEdit;
    cseLabTests: TCCRSearchEdit;
    pnlCoordinators: TPanel;
    cseCoordinators: TCCRSearchEdit;
    csCoordinators: TCCRSelector;
    btnSave: TBitBtn;
    btnApply: TBitBtn;
    btnCancel: TBitBtn;
    tcLabGroups: TTabControl;
    tsLocalFields: TTabSheet;
    tlbFields: TToolBar;
    spbFieldAdd: TSpeedButton;
    spbFieldDelete: TSpeedButton;
    acFieldAdd: TAction;
    acFieldDelete: TAction;
    mnuLocalFields: TPopupMenu;
    Add1: TMenuItem;
    Delete1: TMenuItem;
    tsLabSelRules: TTabSheet;
    cgvLabIndicators: TCCRGridView;
    acFieldRestore: TAction;
    spbFieldRestore: TSpeedButton;
    Restore1: TMenuItem;
    Panel1: TPanel;
    agLocalFields: TCCRAdvColGrid;
    VA508AccessibilityManager1: TVA508AccessibilityManager;
    stxtSearchNotifications: TStaticText;
    stxtSearchMeds: TStaticText;
    stxtSearchLab: TStaticText;

    procedure acApplyExecute(Sender: TObject);
    procedure csCoordinatorsSplitterMoved(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure csRegistryDrugsSplitterMoved(Sender: TObject);
    procedure ActionListUpdate(Action: TBasicAction;
      var Handled: Boolean);
    procedure acSaveExecute(Sender: TObject);
    procedure vxsFormLayoutBeforeOpen(Sender: TObject);
    procedure ccrComponentStateRestoreState(Sender: TObject);
    procedure ccrComponentStateSaveState(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure cseCoordinatorsSearchStart(Sender: TObject; var aCommand: TCCRSearchCommand);
    procedure cseRegistryDrugsSearchStart(Sender: TObject; var aCommand: TCCRSearchCommand);
    procedure cseLabTestsSearchStart(Sender: TObject; var aCommand: TCCRSearchCommand);
    procedure tcLabGroupsChange(Sender: TObject);
    procedure LabTestsResultColumnResize(aSender: TCCRGridView; aColumn: TListColumn);
    procedure LabTestsSourceColumnResize(aSender: TCCRGridView; aColumn: TListColumn);
    procedure LabTestsSplitterMoved(Sender: TObject);
    procedure acFieldAddExecute(Sender: TObject);
    procedure acFieldDeleteExecute(Sender: TObject);
    procedure acFieldRestoreExecute(Sender: TObject);
    procedure agLocalFieldsGetDisplText(Sender: TObject; ACol,
      ARow: Integer; var Value: String);
    procedure agLocalFieldsCellsChanged(Sender: TObject; R: TRect);
    procedure agLocalFieldsCanEditCell(Sender: TObject; ARow,
      ACol: Integer; var CanEdit: Boolean);
    procedure agLocalFieldsGetCellColor(Sender: TObject; ARow,
      ACol: Integer; AState: TGridDrawState; ABrush: TBrush; AFont: TFont);
    procedure pgcMainEnter(Sender: TObject);
    procedure pgcMainChange(Sender: TObject);

  private
    fDrugGroups: TDataGroups;
    fLabGroups: TDataGroups;
    fLocalFieldsRO: Boolean;

    function  canDeleteLocalFields: Boolean;

    procedure initLabTestsPage;

    procedure loadGenericDrugs;
    function  loadLocalFields: TReturnCode;
    procedure loadRegistryCoordinators;
    procedure loadRegistryDrugs;
    procedure loadRegistryLabTests;

    function  saveLocalFields: Boolean;
    procedure saveRegistryCoordinators;
    procedure saveRegistryDrugs;
    procedure saveRegistryLabTests(aLabGroup: TDataGroup);

    procedure searchCoordinators(aTarget: String);
    procedure searchDrugs(aTarget: String);
    procedure searchLabTests(aTarget: String); virtual;

  protected
    ColumnResizing: Boolean;
    fRegInfo: TRegistryInfo;
    SplitterMoving: Boolean;

    procedure CancelAll; virtual; 
    procedure LoadLists; virtual;
    function  SaveAll: Boolean; virtual;

    property DrugGroups: TDataGroups read fDrugGroups;
    property LabGroups: TDataGroups read fLabGroups;
    property RegInfo: TRegistryInfo read fRegInfo;

  public
    constructor Create(aRegInfo: TRegistryInfo; anOwner: TComponent = nil); reintroduce;
    destructor  Destroy; override;

    function  Edit(const aTabIndex: Integer = 0): Integer;
    function  HasBeenModified(var msgStr: String): Boolean; virtual;
    procedure LoadLayout;
    procedure SaveLayout;

  published
    procedure ApplyOptions;

  end;

implementation
{$R *.DFM}

uses
  uROR_Common, uROR_Broker, uROR_Utilities, uROR_Strings, fROR_Options, Variants,
  uROR_CommonUtils, StrUtils, uROR_Classes;

const
  lfiName    = 0;
  lfiInaDate = 1;
  lfiDescr   = 2;
  lfiIEN     = 3;

  ssARVDrugs     = 'ARVDrugSelector';
  ssCoordinators = 'CoordinatorSelector';
  ssGenericDrugs = 'GenericDrugList';
  ssLabTests     = 'LabTestSelector';
  ssLocalFields  = 'LocalFieldList';

/////////////////////////////////// TDataGroup \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

constructor TDataGroup.Create;
begin
  inherited;
  fCode     := '';
  fIEN      := '';
  fSelector := nil;
  fText     := '';
end;

procedure TDataGroup.AssignRawData(const RawData: String);
begin
  fIEN  := Piece(RawData, U, 1);
  fText := Piece(RawData, U, 2);
  fCode := Piece(RawData, U, 3);
end;

////////////////////////////////// TDataGroups \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

constructor TDataGroups.Create(const aDataType: String);
begin
  inherited Create;
  CaseSensitive := False;
  Duplicates    := dupError;
  Sorted        := True;
  fDataType     := aDataType;
end;

destructor TDataGroups.Destroy;
var
  i: Integer;
begin
  for i:=Count-1 downto 0 do
    try
      Objects[i].Free;
      Objects[i] := nil;
    except
    end;
  inherited;
end;

function TDataGroups.Add(aGroup: TDataGroup): Integer;
begin
  Result := AddObject(aGroup.Code, aGroup);
end;

procedure TDataGroups.AssignRawData(RawData: TStrings);
var
  i: Integer;
  grp: TDataGroup;
begin
  BeginUpdate;
  try
    Clear;
    for i:=RawData.Count-1 downto 0 do
      begin
        grp := TDataGroup.Create;
        grp.AssignRawData(RawData[i]);
        Add(grp);
      end;
  finally
    EndUpdate;
  end;
end;

function TDataGroups.getObject(const anIndex: Integer): TDataGroup;
begin
  Result := inherited Objects[anIndex] as TDataGroup;
end;

procedure TDataGroups.Load(const aRegIEN: String);
var
  rawData: TStringList;
begin
  rawData := TStringList.Create;
  try
    if Broker.CallProc(rpcListItems, [aRegIEN,DataType], nil, rawData) then
      begin
        rawData.Delete(0);
        AssignRawData(rawData);
      end;
  finally
    rawData.Free;
  end;
end;

procedure TDataGroups.setObject(const anIndex: Integer; aValue: TDataGroup);
begin
  inherited Objects[anIndex] := aValue;
end;

///////////////////////////// TFormSiteParameters \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

constructor TFormSiteParameters.Create(aRegInfo: TRegistryInfo; anOwner: TComponent);
begin
  if Assigned(anOwner) then
    inherited Create(anOwner)
  else
    inherited Create(Application);

  ColumnResizing := False;
  fRegInfo       := aRegInfo;
  SplitterMoving := False;

  //--- Add the registry name to the dialog box caption
  Caption := RegInfo.Description + ' ' + Caption;

  //--- Load the list of lab test groups. If there are
  //--- none, then hide the 'Laboratory Tests' tab
  fLabGroups := TDataGroups.Create('3');
  LabGroups.Load(RegInfo.IEN);
  if LabGroups.Count > 0 then
    initLabTestsPage
  else
    tsLabTests.TabVisible := False;

  //--- Load the list of registry specific drug groups. If
  //--- there are none, then hide the 'registry Drugs' tab
  fDrugGroups := TDataGroups.Create('4');
  DrugGroups.Load(RegInfo.IEN);
  if DrugGroups.Count <= 0 then
    tsRegistryMeds.TabVisible := False;

  //---
  agLocalFields.HideColumn(lfiIEN);

  LoadLists;
  LoadLayout;
  //The following line was added to patch 10 to fix issue with lists being emptied
  LoadLists;
  ApplyOptions;
end;

destructor TFormSiteParameters.Destroy;
begin
  FreeAndNil(fDrugGroups);
  FreeAndNil(fLabGroups);
  inherited;
end;

procedure TFormSiteParameters.acApplyExecute(Sender: TObject);
begin
  SaveAll;
end;

procedure TFormSiteParameters.acFieldAddExecute(Sender: TObject);
begin
  agLocalFields.AddRow;
end;

procedure TFormSiteParameters.acFieldDeleteExecute(Sender: TObject);
begin
  if canDeleteLocalFields then
    agLocalFields.RemoveSelectedRows;
end;

procedure TFormSiteParameters.acFieldRestoreExecute(Sender: TObject);
var
  i, rri: Integer;
begin
  with agLocalFields do
  begin
    for i:=RowCount-1 downto FixedRows do
      if RowSelect[i] then
      begin
        rri := RealRowIndex(i);
        if GridCells[lfiInaDate,rri] <> '' then
        begin
          AllCells[lfiInaDate,rri] := '';
          Modified := True;
        end;
      end;
  end;
end;

procedure TFormSiteParameters.acSaveExecute(Sender: TObject);
begin
  if  not SaveAll then
    ModalResult := mrNone;
end;

procedure TFormSiteParameters.ActionListUpdate(Action: TBasicAction;
  var Handled: Boolean);
var
  msg: String;
begin
  acApply.Enabled := HasBeenModified(msg);

  if fLocalFieldsRO then
  begin
    acFieldAdd.Enabled     := False;
    acFieldDelete.Enabled  := False;
    acFieldRestore.Enabled := False;
  end
  else if agLocalFields.RowSelectCount > 0 then
  begin
    acFieldDelete.Enabled  := True;
    acFieldRestore.Enabled := True;
  end
  else begin
    acFieldDelete.Enabled  := False;
    acFieldRestore.Enabled := False;
  end
end;

procedure TFormSiteParameters.agLocalFieldsCanEditCell(Sender: TObject;
  ARow, ACol: Integer; var CanEdit: Boolean);
begin
  CanEdit := Not fLocalFieldsRO;
end;

procedure TFormSiteParameters.agLocalFieldsCellsChanged(Sender: TObject;
  R: TRect);
begin
  agLocalFields.Modified := True;
end;

procedure TFormSiteParameters.agLocalFieldsGetCellColor(Sender: TObject;
  ARow, ACol: Integer; AState: TGridDrawState; ABrush: TBrush;
  AFont: TFont);
begin
  with agLocalFields do
    if fLocalFieldsRO and (ARow >= FixedRows) then
    begin
      ABrush.Color := Color;
      AFont.Color  := Font.Color;
    end;
end;

procedure TFormSiteParameters.agLocalFieldsGetDisplText(Sender: TObject;
  ACol, ARow: Integer; var Value: String);
begin
  if (ARow >= agLocalFields.FixedRows) and (ACol = lfiInaDate) then
    Value := FMDateTimeStr(Value, [fmdtDateOnly,fmdtShortDate]);
end;

procedure TFormSiteParameters.ApplyOptions;
var
  ie: TCCRInterfaceElement;
begin
  inherited;
  ie := CCROptions.IE[ieReadOnly];
  //--- List of generic drugs on Registry Meds tab
  lsvGenericDrugs.Color := ie.Color;
  lsvGenericDrugs.Font.Color := ie.FontColor;
  //--- List of Lab Search indicators on the Lab Selection Rules tab
  cgvLabIndicators.Color := ie.Color;
  cgvLabIndicators.Font.Color := ie.FontColor;
  //--- Local fields
  if fLocalFieldsRO then
  begin
    agLocalFields.Color      := ie.Color;
    agLocalFields.Font.Color := ie.FontColor;
  end
  else begin
    agLocalFields.Color      := clWindow;
    agLocalFields.Font.Color := clWindowText;
  end;

  //-- Section 508: Set the Captions on the lists so JAWS will pick them up.
  if CCRScreenReaderActive then
  begin
    lsvGenericDrugs.Fields[1].Caption := 'Generic Registry '
      + lsvGenericDrugs.Fields[1].Caption;
    csRegistryDrugs.SourceList.Fields[1].Caption := 'Available '
      + csRegistryDrugs.SourceList.Fields[1].Caption;
    csRegistryDrugs.ResultList.Fields[1].Caption := 'Local Registry '
      + csRegistryDrugs.ResultList.Fields[1].Caption;
    csCoordinators.SourceList.Fields[1].Caption := 'Available '
      + csCoordinators.SourceList.Fields[1].Caption;
    csCoordinators.ResultList.Fields[1].Caption := 'Selected '
      + csCoordinators.ResultList.Fields[1].Caption;
  end;
end;

procedure TFormSiteParameters.CancelAll;
begin
  with Broker do
    begin
      CreateResults;
      CallProc(rpcUpdateLocalFields, [RegInfo.IEN, '1']);
    end;
end;

function TFormSiteParameters.canDeleteLocalFields: Boolean;
var
  i, rc, rri: Integer;
  inaDate: String;
begin
  Result := False;
  //DEBUG(ETM) was MessageDialog (default = mrCancel)
  rc := MessageDlg508('Delete Local Fields', RSC00250,
    mtWarning, [mbYes,mbNo,mbCancel], 0);
  case rc of
    mrYes:
      Result := True;
    mrNo:
      with agLocalFields do
      begin
        inaDate := FloatToStr(WindowsDateToFMDate(Date));
        for i:=RowCount-1 downto FixedRows do
          if RowSelect[i] then
          begin
            rri := realRowIndex(i);
            if GridCells[lfiInaDate,rri] = '' then
            begin
              GridCells[lfiInaDate,rri] := inaDate;
              Modified := True;
            end;
          end;
      end;
  end;
end;

procedure TFormSiteParameters.ccrComponentStateRestoreState(Sender: TObject);
begin
  csRegistryDrugs.LoadLayout(vxsFormLayout, ssARVDrugs);
  csCoordinators.LoadLayout(vxsFormLayout, ssCoordinators);
  lsvGenericDrugs.LoadLayout(vxsFormLayout, ssGenericDrugs);

  if (LabGroups.Count > 0) and Assigned(LabGroups[0].Selector) then
    LabGroups[0].Selector.LoadLayout(vxsFormLayout, ssLabTests);

  agLocalFields.LoadLayout(vxsFormLayout, ssLocalFields);
end;

procedure TFormSiteParameters.ccrComponentStateSaveState(Sender: TObject);
begin
  csRegistryDrugs.SaveLayout(vxsFormLayout, ssARVDrugs);
  csCoordinators.SaveLayout(vxsFormLayout, ssCoordinators);
  lsvGenericDrugs.SaveLayout(vxsFormLayout, ssGenericDrugs);

  if (LabGroups.Count > 0) and Assigned(LabGroups[0].Selector) then
    LabGroups[0].Selector.SaveLayout(vxsFormLayout, ssLabTests);

  agLocalFields.SaveLayout(vxsFormLayout, ssLocalFields);
end;

procedure TFormSiteParameters.csCoordinatorsSplitterMoved(Sender: TObject);
begin
  with csCoordinators do
    cseCoordinators.Width := SourceList.Width - 44;
end;

procedure TFormSiteParameters.csRegistryDrugsSplitterMoved(Sender: TObject);
begin
  with csRegistryDrugs do
  begin
    cseRegistryDrugs.Width := SourceList.Width - 44;
    pnlLocalRegMeds.Width  := ResultList.Width;
    Panel12.Width          := ResultList.Width;
    lsvGenericDrugs.Width  := ResultList.Width;
  end;
end;

procedure TFormSiteParameters.cseCoordinatorsSearchStart(Sender: TObject;
  var aCommand: TCCRSearchCommand);
begin
  searchCoordinators(cseCoordinators.Text);
  aCommand := cscFinish;
end;

procedure TFormSiteParameters.cseLabTestsSearchStart(Sender: TObject;
  var aCommand: TCCRSearchCommand);
begin
  searchLabTests(cseLabTests.Text);
  aCommand := cscFinish;
end;

procedure TFormSiteParameters.cseRegistryDrugsSearchStart(Sender: TObject;
  var aCommand: TCCRSearchCommand);
begin
  searchDrugs(cseRegistryDrugs.Text);
  aCommand := cscFinish;
end;

function TFormSiteParameters.Edit(const aTabIndex: Integer): Integer;
begin
  if (aTabIndex >= 0) and (aTabIndex < pgcMain.PageCount) then
    pgcMain.ActivePageIndex := aTabIndex;
  Result := ShowModal;
end;

procedure TFormSiteParameters.FormActivate(Sender: TObject);
begin
  //-- Section 508: Display a warning regarding disabled controls.
  if CCRScreenReaderActive then
    MessageDlg508('', RSC50801, mtWarning, [mbOK], 0);

  with pgcMain do
    if not Assigned(ActivePage) or not ActivePage.TabVisible then
      ActivePage := FindNextPage(nil, True, True);
end;

procedure TFormSiteParameters.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  SaveLayout;
  Action := caHide;
end;

procedure TFormSiteParameters.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
var
  msg: String;
  dlgR: Integer;
begin
  if HasBeenModified(msg) then
  begin
    msg := RSC00151 + #13#13 + msg + #13 + RSC00152;
    //DEBUG(ETM) was MessageDialog (default = mrCancel)
    dlgR := MessageDlg508(RSC00150, msg, mtConfirmation, mbYesNoCancel, 0);
    case dlgR of
      mrYes:    CanClose := SaveAll;
      mrCancel: CanClose := False;
      else      CancelAll;
    end;
  end
  else
    CancelAll;
end;

function TFormSiteParameters.HasBeenModified(var msgStr: String): Boolean;
var
  i, n: Integer;
begin
  msgStr := '';
  if csRegistryDrugs.ResultChanged then
    msgStr := msgStr + RSC00156 + #13;
  if csCoordinators.ResultChanged then
    msgStr := msgStr + RSC00157 + #13;

  n := LabGroups.Count - 1;
  for i:=0 to n do
    if LabGroups[i].Selector.ResultChanged then
      msgStr := msgStr + Format(RSC00153, [LabGroups[i].Text]) + #13;

  if agLocalFields.Modified then
    msgStr := msgStr + RSC00154 + #13;

  Result := (msgStr <> '');
end;

procedure TFormSiteParameters.initLabTestsPage;
var
  iLg, nLg: Integer;
begin
  nLg := LabGroups.Count - 1;

  //--- Create tabs and selectors for the lab test groups
  for iLg:=0 to nLg do
  begin
    tcLabGroups.Tabs.Add(LabGroups[iLg].Text);
    LabGroups[iLg].Selector := TCCRSelector.Create(Self);
    with LabGroups[iLg].Selector do
    begin
      Name   := Format('csLabSel%d', [iLg]);
      Parent := tsLabTests;
      if iLg <> tcLabGroups.TabIndex then
        Visible := False;
      //-- Section 508: Moved IDField from position 0 to 2.
      IDField := 2;
    end;
  end;
  tcLabGroups.TabIndex := 0;

  //--- Add the SplitPos property of the first lab test selector to
  //    the list of saved/restored properties. Splitters of all lab
  //--- test selectors are synchronised and will be affected also.
  with LabGroups[0] do
    ccrComponentState.StoredProperties.AddObject(Selector.Name+'.SplitPos', Selector);

  //--- Fine-tune the lab test selectors
  for iLg:=0 to nLg do
    with LabGroups[iLg].Selector do
      begin
        Align          := alClient;
        OnSplitterMoved := LabTestsSplitterMoved;

        with ResultList do
        begin
          //-- Section 508: Add "Dummy" column so that JAWS will pick up headers
          //   correctly. Move IEN field from position 0 to 2. Dummy column was
          //   always showing so we hide it if no screen reader is in use.
          with TCCRGridField(Fields.Add) do
          begin
            Caption     := 'Dummy508';
            Visible     := CCRScreenReaderActive;
            MinWidth    := 1;
            Width       := 1;
            MaxWidth    := 1;
            AllowResize := false;
            AllowSort   := false;
          end;
          with TCCRGridField(Fields.Add) do
          begin
            if CCRScreenReaderActive then
              Caption := 'Selected Test Name'
            else
              Caption := 'Test Name';
            Width   := 200;
          end;
          with TCCRGridField(Fields.Add) do
          begin
            Caption := 'IEN';
            Visible := false;
          end;

          GridLines      := False;
          HideSelection  := True;
          MultiSelect    := True;
          OnColumnResize := LabTestsResultColumnResize;
          ReadOnly       := True;
          RowSelect      := True;
          SortField      := 1;
        end;

        with SourceList do
        begin
          //-- Section 508: Add "Dummy" column so that JAWS will pick up headers
          //   correctly. Move IEN field from position 0 to 2. Dummy column was
          //   always showing so we hide it if no screen reader is in use.
          with TCCRGridField(Fields.Add) do
          begin
            Caption     := 'Dummy508';
            Visible     := CCRScreenReaderActive;
            MinWidth    := 1;
            Width       := 1;
            MaxWidth    := 1;
            AllowResize := false;
            AllowSort   := false;
          end;
          with Fields.Add as TCCRGridField do
          begin
            if CCRScreenReaderActive then
              Caption := 'Available Test Name'
            else
              Caption := 'Test Name';
            Width   := 200;
          end;
          with Fields.Add as TCCRGridField do
          begin
            Caption := 'IEN';
            Visible := false;
          end;

          GridLines      := False;
          HideSelection  := True;
          MultiSelect    := True;
          OnColumnResize := LabTestsSourceColumnResize;
          ReadOnly       := True;
          RowSelect      := True;
          SortField      := 1;
        end;

        Constraints.MinHeight := 41;
        Constraints.MinWidth  := 96;
      end;
end;

procedure TFormSiteParameters.LabTestsResultColumnResize(
  aSender: TCCRGridView; aColumn: TListColumn);
var
  fldNdx, i, wd: Integer;
begin
  if ColumnResizing then Exit;
  fldNdx := aSender.FieldIndex(aColumn.Index);
  if fldNdx < 0 then Exit;
  //--- Synchronise the column width in all lab test selectors
  ColumnResizing := True;
  try
    wd := LabGroups[0].Selector.ResultList.Width - 40;
    for i := LabGroups.Count-1 downto 0 do
      LabGroups[i].Selector.ResultList.Fields[fldNdx].Width := wd;
  finally
    ColumnResizing := False;
  end;
end;

procedure TFormSiteParameters.LabTestsSourceColumnResize(
  aSender: TCCRGridView; aColumn: TListColumn);
var
  fldNdx, i, wd: Integer;
begin
  if ColumnResizing then Exit;
  fldNdx := aSender.FieldIndex(aColumn.Index);
  if fldNdx < 0 then Exit;
  //--- Synchronise the column width in all lab test selectors
  ColumnResizing := True;
  try
    wd := LabGroups[0].Selector.SourceList.Width - 40;
    for i := LabGroups.Count-1 downto 0 do
      LabGroups[i].Selector.SourceList.Fields[fldNdx].Width := wd;
  finally
    ColumnResizing := False;
  end;
end;

procedure TFormSiteParameters.LabTestsSplitterMoved(Sender: TObject);
var
  i: Integer;
begin
  if SplitterMoving then Exit;

  SplitterMoving := True;
  try
    with TCCRSelector(Sender) do
    begin
      if SplitPos > 90 then SplitPos := 90;
      if SplitPos < 10 then SplitPos := 10;
      //--- Synchronise the splitter position in all lab test selectors
      for i := LabGroups.Count-1 downto 0 do
        LabGroups[i].Selector.SplitPos := SplitPos;
      //--- Resize the search pattern editor and tab control
      cseLabTests.Width := SourceList.Width - 44;
      tcLabGroups.Width := ResultList.Width;
    end;
  finally
    SplitterMoving := False;
  end;
end;

procedure TFormSiteParameters.loadGenericDrugs;
begin
  if DrugGroups.Count > 0 then
  begin
    Broker.CreateResults;
    Screen.Cursor := crHourGlass;
    try
      if Broker.CallProc(rpcListGenericDrugs, [RegInfo.IEN,'99']) then
      begin
        Broker.Results.Delete(0);
        lsvGenericDrugs.Items.AssignRawData(Broker.Results, [-99,2,3]);
      end;
    finally
      Screen.Cursor := crDefault;
    end;
  end;
end;

procedure TFormSiteParameters.LoadLayout;
begin
  vxsFormLayout.Open;
  try
    ccrFormState.RestoreState;
    ccrComponentState.RestoreState;
  except
  end;
  vxsFormLayout.Close;
end;

procedure TFormSiteParameters.LoadLists;
begin
  loadRegistryDrugs;
  loadRegistryCoordinators;
  loadGenericDrugs;
  loadRegistryLabTests;
  loadLocalFields;
  //The following line was commented out to fix issue in patch 10
  //ApplyOptions;
end;

function TFormSiteParameters.loadLocalFields: TReturnCode;
var
  rawData: TStringList;
  lockErr: TLockError;
begin
  Result := RC_OK;
  Screen.Cursor := crHourGlass;
  try
    rawData := TStringList.Create;
    try
      if Broker.CallProc(rpcListLocalFields, [RegInfo.IEN,'I','1'], nil, rawData) then
      begin
        lockErr := TLockError.Create(Piece(rawData[0],U,2,99), 'Local field table');
        try
          Result := lockErr.Show(False);
        finally
          lockErr.Free;
        end;
        rawData.Delete(0);
        agLocalFields.AssignRawData(rawData, [2,3,4,1]);
      end;
    finally
      rawData.Free;
    end;
    fLocalFieldsRO := (Result <> RC_OK);
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TFormSiteParameters.loadRegistryCoordinators;
var
  rawData: TStringList;
begin
  Screen.Cursor := crHourGlass;
  try
    rawData := TStringList.Create;
    try
      csCoordinators.ResultChanged := False;
      if Broker.CallProc(rpcListCoordinators, [RegInfo.IEN], nil, rawData) then
      begin
        rawData.Delete(0);
        csCoordinators.ResultList.Items.AssignRawData(rawData, [-99,2,1]);
      end;
    finally
      rawData.Free;
    end;
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TFormSiteParameters.loadRegistryDrugs;
var
  rawData: TStringList;
begin
  if DrugGroups.Count > 0 then
  begin
    Screen.Cursor := crHourGlass;
    try
      rawData := TStringList.Create;
      try
        csRegistryDrugs.ResultChanged := False;
        if Broker.CallProc(rpcListLocalDrugs, [RegInfo.IEN,'99'], nil, rawData) then
        begin
          rawData.Delete(0);
          csRegistryDrugs.ResultList.Items.AssignRawData(rawData, [-99,2,3]);
        end;
      finally
        rawData.Free;
      end;
    finally
      Screen.Cursor := crDefault;
    end;
  end;
end;

procedure TFormSiteParameters.loadRegistryLabTests;
var
  i: Integer;
  rawData: TStringList;
begin
  if LabGroups.Count > 0 then
  begin
    Screen.Cursor := crHourGlass;
    try
      rawData := TStringList.Create;
      try
        for i:=LabGroups.Count-1 downto 0 do
          with LabGroups[i].Selector do
          begin
            ResultChanged := False;
            rawData.Clear;
            if Broker.CallProc(rpcListLocalLabTests,
              [RegInfo.IEN, LabGroups[i].Code], nil, rawData) then
            begin
              rawData.Delete(0);
              ResultList.Items.AssignRawData(rawData, [-99,2,3]);
            end;
          end;
      finally
        rawData.Free;
      end;
    finally
      Screen.Cursor := crDefault;
    end;
  end;
end;

procedure TFormSiteParameters.pgcMainChange(Sender: TObject);
begin
  pgcMain.HelpContext := pgcMain.ActivePage.HelpContext;
end;

procedure TFormSiteParameters.pgcMainEnter(Sender: TObject);
begin
  pgcMain.HelpContext := pgcMain.ActivePage.HelpContext;
end;

function TFormSiteParameters.SaveAll: Boolean;
var
  i: Integer;
begin
  Result := True;

  if csRegistryDrugs.ResultChanged then
    saveRegistryDrugs;
  if csCoordinators.ResultChanged then
    saveRegistryCoordinators;

  for i:=LabGroups.Count-1 downto 0 do
    if LabGroups[i].Selector.ResultChanged then
      saveRegistryLabTests(LabGroups[i]);

  if agLocalFields.Modified then
    if Not saveLocalFields then
      Result := False;
end;

procedure TFormSiteParameters.SaveLayout;
begin
  vxsFormLayout.Open;
  try
    ccrFormState.SaveState;
    ccrComponentState.SaveState;
  except
  end;
  vxsFormLayout.Close;
end;

function TFormSiteParameters.saveLocalFields: Boolean;
var
  ir: Integer;
  rawData, resData: TStringList;
  lockerr: TLockError;
begin
  Result := False;
  Screen.Cursor := crHourGlass;
  try
    rawData := TStringList.Create;
    resData := TStringList.Create;
    try
      with agLocalFields do
      begin
        for ir:=RowCount-1 downto 0 do
          if AllCells[lfiName,ir] = '' then
            RemoveRow(ir);
        agLocalFields.GetRawData(rawData, [3,0,1,2]);
        if Broker.CallProc(rpcUpdateLocalFields,
          [RegInfo.IEN, '0'], rawData, resData) then
        begin
          lockerr := TLOckError.Create(resData[0], 'Local fields');
          try
            Result := (lockerr.Show = RC_OK);
          finally
            lockerr.Free;
          end;
        end;
        Modified := Not Result;
      end;
    finally
      resData.Free;
      rawData.Free;
    end;
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TFormSiteParameters.saveRegistryCoordinators;
var
  rawData, resData: TStringList;
begin
  Screen.Cursor := crHourGlass;
  try
    rawData := TStringList.Create;
    resData := TStringList.Create;
    try
      with csCoordinators do
        begin
          ResultList.Items.GetRawData(rawData, [2]);
          ResultChanged := not Broker.CallProc(rpcUpdateCoordinators,
            [RegInfo.IEN], rawData, resData);
        end;
    finally
      resData.Free;
      rawData.Free;
    end;
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TFormSiteParameters.saveRegistryDrugs;
var
  rawData, resData: TStringList;
begin
  Screen.Cursor := crHourGlass;
  try
    rawData := TStringList.Create;
    resData := TStringList.Create;
    try
      with csRegistryDrugs do
        begin
          ResultList.Items.GetRawData(rawData, [-1,-1,2]);
          ResultChanged := not Broker.CallProc(rpcUpdateLocalDrugs,
            [RegInfo.IEN,'99'], rawData, resData);
        end;
    finally
      resData.Free;
      rawData.Free;
    end;
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TFormSiteParameters.saveRegistryLabTests(aLabGroup: TDataGroup);
var
  rawData, resData: TStringList;
begin
  Screen.Cursor := crHourGlass;
  try
    rawData := TStringList.Create;
    resData := TStringList.Create;
    try
      with aLabGroup.Selector do
        begin
          ResultList.Items.GetRawData(rawData, [-1,-1,2]);
          ResultChanged := not Broker.CallProc(rpcUpdateLocalLabTests,
            [RegInfo.IEN, aLabGroup.Code], rawData, resData);
        end;
    finally
      resData.Free;
      rawData.Free;
    end;
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TFormSiteParameters.searchCoordinators(aTarget: String);
var
  rawData: TStringList;
begin
  Screen.Cursor := crHourGlass;
  try
    rawData := TStringList.Create;
    try
      if Broker.CallProc(rpcListVistaUsers, [aTarget], nil, rawData) then
        begin
          rawData.Delete(0);
          csCoordinators.SourceList.Items.AssignRawData(rawData, [-99,2,1]);
          csCoordinators.SourceList.Activate;
        end;
    finally
      rawData.Free;
    end;
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TFormSiteParameters.searchDrugs(aTarget: String);
var
  rawData: TStringList;
begin
  Screen.Cursor := crHourGlass;
  try
    rawData := TStringList.Create;
    try
      if Broker.CallProc(rpcListDrugs, [aTarget], nil, rawData) then
        begin
          rawData.Delete(0);
          csRegistryDrugs.SourceList.Items.AssignRawData(rawData, [-99,2,1]);
          csRegistryDrugs.SourceList.Activate;
        end;
    finally
      rawData.Free;
    end;
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TFormSiteParameters.searchLabTests(aTarget: String);
var
  rawData: TStringList;
begin
  Screen.Cursor := crHourGlass;
  try
    rawData := TStringList.Create;
    with LabGroups[tcLabGroups.TabIndex].Selector do
      try
        if Broker.CallProc(rpcListLaboratoryTests,
          ['',aTarget], nil, rawData) then
          begin
            rawData.Delete(0);
            SourceList.Items.AssignRawData(rawData, [-99,2,1]);
            SourceList.Activate;
          end;
      finally
        rawData.Free;
      end;
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TFormSiteParameters.tcLabGroupsChange(Sender: TObject);
var
  i: Integer;
begin
  //--- Show the corresponding lab test selector
  with LabGroups[tcLabGroups.TabIndex].Selector do
  begin
    Visible := True;
    BringToFront;
    cseLabTests.Width  := SourceList.Width - 44;
    tcLabGroups.Width  := ResultList.Width;
  end;

  //--- Hide all other lab test selectors
  for i := LabGroups.Count-1 downto 0 do
    if i <> tcLabGroups.TabIndex then
      LabGroups[i].Selector.Visible := False;
end;

procedure TFormSiteParameters.vxsFormLayoutBeforeOpen(Sender: TObject);
begin
  vxsFormLayout.Broker := Broker;
end;
{
procedure TFormSiteParameters.agLocalFieldsEditChange(Sender: TObject;
  ACol, ARow: Integer; Value: String);
begin
  with agLocalFields.NormalEdit do
    begin
      Height := 60;
      WordWrap := True;
    end;
end;
}
end.

